/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIEFPGACSPKT_H
#define PCIEFPGACSPKT_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

#define FPGATXMISC_SIDATA_DWNUM               ( ( UInt8 ) 4 ) // DWords
#define FPGATXMISC_SIHEADER_DWNUM             ( ( UInt8 ) 4 ) // DWords

#define FPGATXMISC_SICTRL_SEND_BIT            ( ( UInt8 ) 0 )
#define FPGATXMISC_SICTRL_SWTAG_BIT           ( ( UInt8 ) 3 )
#define FPGATXMISC_SICTRL_DATA_INDICATOR_BIT  ( ( UInt8 ) 4 )
#define FPGATXMISC_SICTRL_NOT_SRC_SIMEM_BIT   ( ( UInt8 ) 5 )
#define FPGATXMISC_SICTRL_BUSERROR_START_BIT  ( ( UInt8 ) 6 )
#define FPGATXMISC_SICTRL_BUSERROR_BIT_SIZE   ( ( UInt8 ) 9 )

/* individual bits for send immediate for different channels */
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELA           ( ( UInt8 )  0 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELB           ( ( UInt8 )  1 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELC           ( ( UInt8 ) 15 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELBVF1        ( ( UInt8 ) 16 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELBVF2        ( ( UInt8 ) 17 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELCVF1        ( ( UInt8 ) 18 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELCVF2        ( ( UInt8 ) 19 )

#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELD           ( ( UInt8 ) 20 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELE           ( ( UInt8 ) 21 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELDVF1        ( ( UInt8 ) 22 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELDVF2        ( ( UInt8 ) 23 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELEVF1        ( ( UInt8 ) 24 )
#define FPGATXMISC_SICTRL_SEND_BIT_HWCHANNELEVF2        ( ( UInt8 ) 25 )

const AgtValueT PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY4 = 256; // copy from devpcieintdefs.h

#define NOFHWCHANNELS  ( ( UInt8 )PCIE_HWCHANNEL_FUNCTION_END )

enum EExerciserMode
{
  EFPGA_PCIE_MODE,
  EFPGA_SRIOV_MODE,
  EFPGA_MRIOV_MODE,
  EFPGA_RSVD_MODE
};

class CAgtPCIEControl;

class CPCIEFpgaCSPkt
{
public:

  // = FOUNDATION
  CPCIEFpgaCSPkt( void );
  ~CPCIEFpgaCSPkt( void );

  enum SiCtrl
  {
    SICTRL_SEND,
    SICTRL_SWTAG,
    SICTRL_RESOURCE,
    SICTRL_BUSERROR,
    SICTRL_SIZE
  };

  enum TxMiscCtrlBit
  {
    FPGATXMISC_CTRL_START_REQ_GEN_A_BIT                         =  0,
    FPGATXMISC_CTRL_REQ_GEN_A_SINGLESHOT_MODE_BIT               =  2,
    FPGATXMISC_CTRL_START_REQ_GEN_B_BIT                         =  3,
    FPGATXMISC_CTRL_REQ_GEN_B_SINGLESHOT_MODE_BIT               =  5,
    FPGATXMISC_CTRL_START_REQ_GEN_C_BIT                         =  6,
    FPGATXMISC_CTRL_REQ_GEN_C_SINGLESHOT_MODE_BIT               =  8,
    FPGATXMISC_CTRL_START_REQ_GEN_BVF1_BIT                      =  9,
    FPGATXMISC_CTRL_REQ_GEN_BVF1_SINGLESHOT_MODE_BIT            = 11,
    FPGATXMISC_CTRL_START_REQ_GEN_BVF2_BIT                      = 12,
    FPGATXMISC_CTRL_REQ_GEN_BVF2_SINGLESHOT_MODE_BIT            = 14,
    FPGATXMISC_CTRL_START_REQ_GEN_CVF1_BIT                      = 15,
    FPGATXMISC_CTRL_REQ_GEN_CVF1_SINGLESHOT_MODE_BIT            = 17,
    FPGATXMISC_CTRL_START_REQ_GEN_CVF2_BIT                      = 18,
    FPGATXMISC_CTRL_REQ_GEN_CVF2_SINGLESHOT_MODE_BIT            = 20,
    FPGATXMISC_CTRL_TEST_INTERRUPT_BIT                          = 23,
    FPGATXMISC_CTRL_START_COMP_ALL_BIT                          = 24,
    FPGATXMISC_CTRL_STOP_COMP_MEM_ALL_BIT                       = 26,
    FPGATXMISC_CTRL_START_REQ_GEN_BIT                           = 28,
    FPGATXMISC_CTRL_STOP_REQ_GEN_BIT                            = 29,
    FPGATXMISC_CTRL_RCB_VALUE_BIT                               = 31
  };

  enum TxMiscCtrlExtendedBit
  {
    FPGATXMISC_CTRL_START_REQ_GEN_D_BIT                         =  0,
    FPGATXMISC_CTRL_REQ_GEN_D_SINGLESHOT_MODE_BIT               =  1,
    FPGATXMISC_CTRL_START_REQ_GEN_E_BIT                         =  2,
    FPGATXMISC_CTRL_REQ_GEN_E_SINGLESHOT_MODE_BIT               =  3,
    FPGATXMISC_CTRL_START_REQ_GEN_DVF1_BIT                      =  4,
    FPGATXMISC_CTRL_REQ_GEN_DVF1_SINGLESHOT_MODE_BIT            =  5,
    FPGATXMISC_CTRL_START_REQ_GEN_DVF2_BIT                      =  6,
    FPGATXMISC_CTRL_REQ_GEN_DVF2_SINGLESHOT_MODE_BIT            =  7,
    FPGATXMISC_CTRL_START_REQ_GEN_EVF1_BIT                      =  8,
    FPGATXMISC_CTRL_REQ_GEN_EVF1_SINGLESHOT_MODE_BIT            =  9,
    FPGATXMISC_CTRL_START_REQ_GEN_EVF2_BIT                      = 10,
    FPGATXMISC_CTRL_REQ_GEN_EVF2_SINGLESHOT_MODE_BIT            = 11
  };

  enum TxMiscStatusBit
  {
    FPGATXMISC_STATUS_COMPLETION_GENERATOR_FC_GATE_CLOSED_BIT   =  3,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_A_RUNNING_BIT    =  8,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_A_IDLE_BIT       =  9,
    FPGATXMISC_STATUS_HW_CHANNEL_A_FC_GATE_CLOSED_BIT           = 10,
    FPGATXMISC_STATUS_HW_CHANNEL_A_NO_TAG_AVAILABLE_BIT         = 11, 
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_B_RUNNING_BIT    = 16,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_B_IDLE_BIT       = 17,
    FPGATXMISC_STATUS_HW_CHANNEL_B_FC_GATE_CLOSED_BIT           = 18,
    FPGATXMISC_STATUS_HW_CHANNEL_B_NO_TAG_AVAILABLE_BIT         = 19,
  };

  enum TxMiscHwChannelStatusBit
  {
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_C_RUNNING_BIT    =  0,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_C_IDLE_BIT       =  1,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_BVF1_RUNNING_BIT =  4,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_BVF1_IDLE_BIT    =  5,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_BVF2_RUNNING_BIT =  8,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_BVF2_IDLE_BIT    =  9,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_CVF1_RUNNING_BIT = 12,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_CVF1_IDLE_BIT    = 13,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_CVF2_RUNNING_BIT = 16,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_CVF2_IDLE_BIT    = 17
  };

  enum TxMiscHwChannelStatusExtendedBit
  {
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_D_RUNNING_BIT    =  4,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_D_IDLE_BIT       =  5,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_E_RUNNING_BIT    =  8,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_E_IDLE_BIT       =  9,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_DVF1_RUNNING_BIT = 12,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_DVF1_IDLE_BIT    = 13,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_DVF2_RUNNING_BIT = 16,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_DVF2_IDLE_BIT    = 17,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_EVF1_RUNNING_BIT = 20,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_EVF1_IDLE_BIT    = 21,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_EVF2_RUNNING_BIT = 24,
    FPGATXMISC_STATUS_REQUEST_HEADER_GENERATOR_EVF2_IDLE_BIT    = 25
  };

  typedef enum TxMiscBlockMemoryState
  {
    FPGATXMISC_BLOCKMEMORY_STATE_STOPPING                       =  0,
    FPGATXMISC_BLOCKMEMORY_STATE_RUNNING                        =  1,
    FPGATXMISC_BLOCKMEMORY_STATE_STOPPED                        =  2,
    FPGATXMISC_BLOCKMEMORY_STATE_INVALID                        =  3
  };

  enum TxMiscControlStatusBit
  {
    TXMISC_CONTROLSTATUS_CTRL_RESET_STATUSBITS_BIT              =  0,
    TXMISC_CONTROLSTATUS_CTRL_RESET_SYSTEM_CLOCK_DCM_BIT        =  1,
    TXMISC_CONTROLSTATUS_CTRL_ASSERT_WIDE_CPU_RST_N_BIT         =  2,
    TXMISC_CONTROLSTATUS_CTRL_RELEASE_CPU_IF_BIT                =  3,
    TXMISC_CONTROLSTATUS_CTRL_RELEASE_CPU_IF_INTERRUPT          =  4,
    TXMISC_CONTROLSTATUS_STATUS_DCM_LOCKED_BIT                  = 16,
    TXMISC_CONTROLSTATUS_STATUS_FREQUENCY_OK_BIT                = 17,
    TXMISC_CONTROLSTATUS_STATUS_IF_BLOCKED_BIT                  = 18,
    TXMISC_CONTROLSTATUS_STATUS_FREQUENCY_CHECK_BIT             = 19,
    TXMISC_CONTROLSTATUS_STATUS_PROTOCOL_ERROR_BIT              = 20,
    TXMISC_CONTROLSTATUS_STATUS_INTERRUPT_BIT                   = 21
  };

  // = ACTION
  UInt32 getTxCtrl( const AgtPortHandleT& portHandle );
  void   setTxCtrl( const AgtPortHandleT& portHandle, const UInt32& val );
  UInt32 getTxCtrlExtended( const AgtPortHandleT& portHandle );
  void   setTxCtrlExtended( const AgtPortHandleT& portHandle, const UInt32& val );

  UInt32 getTxPktStatus( const AgtPortHandleT& portHandle );
  void   setTxPktStatus( const AgtPortHandleT& portHandle, const UInt32& val );

  UInt32 getTxPktStatusHwChannels( const AgtPortHandleT& portHandle );
  void   setTxPktStatusHwChannels( const AgtPortHandleT& portHandle, const UInt32& val );

  UInt32 getTxPktStatusExtendedHwChannels( const AgtPortHandleT& portHandle );
  void   setTxPktStatusExtendedHwChannels( const AgtPortHandleT& portHandle, const UInt32& val );

  UInt32 getBlockRepeatFirst( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setBlockRepeatFirst( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getBlockRepeatSecond( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setBlockRepeatSecond( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getBlockRepeatThird( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setBlockRepeatThird( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getBlockRepeatFourth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setBlockRepeatFourth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getBlockRepeatFifth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setBlockRepeatFifth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );

  UInt32 getReqBehRepeatFirst( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setReqBehRepeatFirst( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getReqBehRepeatSecond( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setReqBehRepeatSecond( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getReqBehRepeatThird( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setReqBehRepeatThird( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getReqBehRepeatFourth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setReqBehRepeatFourth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );
  UInt32 getReqBehRepeatFifth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel );
  void   setReqBehRepeatFifth( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const UInt32& val );

  UInt32 getCompBehRepeatFirst( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue );
  void   setCompBehRepeatFirst( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& val );
  UInt32 getCompBehRepeatSecond( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue );
  void   setCompBehRepeatSecond( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& val );

  UInt32 getBlockPointers( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const bool& first );
  void   setBlockPointers( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const bool& first, const UInt32& val );
  UInt32 getReqBehPointers( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const bool& first );
  void   setReqBehPointers( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& hwChannel,
    const bool& first, const UInt32& val );
  UInt32 getCompBehPointers( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const bool& first );
  void   setCompBehPointers( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const bool& first,
    const UInt32& val );

  UInt32 getSiCtrl( const AgtPortHandleT& portHandle, const SiCtrl& ctrl );
  void   setSiCtrl( const AgtPortHandleT& portHandle, const SiCtrl& ctrl, const UInt32& val );
  UInt32 getSiHeader( const AgtPortHandleT& portHandle, const UInt32& idx );
  void   setSiHeader( const AgtPortHandleT& portHandle, const UInt32& idx, const UInt32& val );
  void   setSiHeaderProp( const AgtPortHandleT& portHandle, const EPCIESi& prop, const UInt32& val );
  UInt32 getSiHeaderProp( const AgtPortHandleT& portHandle, const EPCIESi& prop );
  void   setSiHeaderPropDefault( const AgtPortHandleT& portHandle, const EPCIESi& prop );
  UInt32 getSiHeaderPropDefault( const EPCIESi& prop );
  UInt32 getSiDataDW( const AgtPortHandleT& portHandle, const UInt8& idx );
  void   setSiDataDW( const AgtPortHandleT& portHandle, const UInt8& idx, const UInt32& val );

  // Completer (behavior) delay
  UInt32 getDelayComplQueue( const AgtPortHandleT& portHandle, UInt32 queue );
  void   setDelayComplQueue( const AgtPortHandleT& portHandle, UInt32 queue, UInt32 val );

  UInt32 getSiIntAddr( const AgtPortHandleT& portHandle );
  void   setSiIntAddr( const AgtPortHandleT& portHandle, const UInt32& val );
  UInt32 getStatusPropVal( const AgtPortHandleT& portHandle, const EPCIETxStatus& prop );
  TxMiscBlockMemoryState getBlockMemoryState( const AgtPortHandleT& portHandle,
    const EPCIEHwChannelFunction& hwChannel );
  //UInt32 getBlockMemoryStates(const AgtPortHandleT& portHandle);

  void   setBits( UInt32& val, const UInt8& bitPos, const UInt8& bitSize, const UInt32& bitVal );
  UInt32 getBits( const UInt32& val, const UInt8& bitPos, const UInt8& bitSize );
  UInt8  getBitPosRepeatFirst( const EPCIEHwChannelFunction& hwChannel );
  UInt8  getBitPosRepeatSecond( const EPCIEHwChannelFunction& hwChannel );
  UInt8  getBitPosRepeatThird( const EPCIEHwChannelFunction& hwChannel );
  UInt8  getBitPosRepeatFourth( const EPCIEHwChannelFunction& hwChannel );
  UInt8  getBitPosRepeatFifth( const EPCIEHwChannelFunction& hwChannel );

  UInt8  getBitPosRepeatFirst( const EPCIECompQueue& queue );

  // Sets the value into mSendImmediateEnabled array
  void setValueSendImmediateArray( const AgtPortHandleT& portHandle, UInt32 hwChannel );
  // Gets the value from mSendImmediateEnabled array
  EPCIEHwChannelFunction getValueSendImmediateArray( const AgtPortHandleT& portHandle );

private:

  // Registers addresses
  UInt32 mTxCtrl;
  UInt32 mTxCtrlExtended;
  UInt32 mTxPktStatus;
  UInt32 mTxPktStatusHwChannels;
  UInt32 mTxPktStatusExtended;

  UInt32 mBlockAPointers;
  UInt32 mBlockBPointers;
  UInt32 mBlockCPointers;
  UInt32 mBlockDPointers;
  UInt32 mBlockEPointers;
  UInt32 mBlockBVF1Pointers;
  UInt32 mBlockBVF2Pointers;
  UInt32 mBlockCVF1Pointers;
  UInt32 mBlockCVF2Pointers;
  UInt32 mBlockDVF1Pointers;
  UInt32 mBlockDVF2Pointers;
  UInt32 mBlockEVF1Pointers;
  UInt32 mBlockEVF2Pointers;

  UInt32 mReqBehAPointers;
  UInt32 mReqBehBPointers;
  UInt32 mReqBehCPointers;
  UInt32 mReqBehDPointers;
  UInt32 mReqBehEPointers;
  UInt32 mReqBehBVF1Pointers;
  UInt32 mReqBehBVF2Pointers;
  UInt32 mReqBehCVF1Pointers;
  UInt32 mReqBehCVF2Pointers;
  UInt32 mReqBehDVF1Pointers;
  UInt32 mReqBehDVF2Pointers;
  UInt32 mReqBehEVF1Pointers;
  UInt32 mReqBehEVF2Pointers;

  UInt32 mReqComplQueue0Pointers;
  UInt32 mReqComplQueue1Pointers;
  UInt32 mReqComplQueue2Pointers;
  UInt32 mReqComplQueue3Pointers;
  UInt32 mReqComplQueue4Pointers;

  UInt32 mBlockRepeatFirst;
  UInt32 mBlockRepeatSecond;
  UInt32 mBlockRepeatThird;
  UInt32 mBlockRepeatFourth;
  UInt32 mBlockRepeatFifth;

  UInt32 mReqBehRepeatFirst;
  UInt32 mReqBehRepeatSecond;
  UInt32 mReqBehRepeatThird;
  UInt32 mReqBehRepeatFourth;
  UInt32 mReqBehRepeatFifth;

  UInt32 mComplBehRepeatFirst;
  UInt32 mComplBehRepeatSecond;

  UInt32 mComplDelayQueue0;
  UInt32 mComplDelayQueue1;
  UInt32 mComplDelayQueue2;
  UInt32 mComplDelayQueue3;
  UInt32 mComplDelayQueue4;

  UInt32 mSiCtrl;
  UInt32 mSiIntAddr;
  UInt32 mSiHeader0;
  UInt32 mSiHeader1;
  UInt32 mSiHeader2;
  UInt32 mSiHeader3;
  UInt32 mSiDataDW0;
  UInt32 mSiDataDW1; 
  UInt32 mSiDataDW2; 
  UInt32 mSiDataDW3; 

  UInt32 swapDW( const UInt32& val );

  bool mSendImmediateEnabled[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY4][NOFHWCHANNELS];

  CAgtPCIEControl* myController;
};

#endif /* PCIEFPGACSPKT_H */